/**
 * 
 */
package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.Map;

/**
 * @author DNS
 *
 */
public class FeatureFieldTestAwareServiceLocator<T extends PhrService, N extends QueryRequest> extends
		PojoPhrServiceLocator<T, N> {
	
	private StagingService staginingService;
	
	private Map<String, QueryServiceFieldTestInfo> extractTypeQueryServiceFieldTestInfoMap;

	@Override
	public String getServiceId(String userid, String serviceType)
			throws ServiceLocatorException {
		
		QueryServiceFieldTestInfo queryServiceFieldTestInfo = this.extractTypeQueryServiceFieldTestInfoMap.get(serviceType);
		if(queryServiceFieldTestInfo != null)
		{
			// need to determine if the feature has been nationally deployed
			if(this.staginingService.isNationallyReleased(queryServiceFieldTestInfo.getFeature()) || 
					this.staginingService.isFieldTester(userid, queryServiceFieldTestInfo.getFieldTestName())) {
				return String.format("%s%s", queryServiceFieldTestInfo.getFieldTestQueryServiceQualifier(), serviceType);
			}
		}
		
		return super.getServiceId(userid, serviceType);
	}
	
	public void setStaginingService(StagingService staginingService) {
		this.staginingService = staginingService;
	}
	
	public void setExtractTypeQueryServiceFieldTestInfoMap(
			Map<String, QueryServiceFieldTestInfo> extractTypeQueryServiceFieldTestInfoMap) {
		this.extractTypeQueryServiceFieldTestInfoMap = extractTypeQueryServiceFieldTestInfoMap;
	}
}
